<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

$genesis_active_theme = wp_get_theme();
?>
<div class="wrap">
	<div class="genesis-onboarding-page-wrap genesis-onboarding-page-starter-packs">
		<main class="genesis-onboarding-main">
			<h1 class="genesis-onboarding-intro-title">
				<?php
				/* translators: %s: Theme name */
				echo esc_html( sprintf( __( 'Get started with %s.', 'genesis' ), $genesis_active_theme['Name'] ) );
				?>
			</h1>
			<div class="genesis-onboarding-intro-text">
				<p>
				<?php
				/* translators: %s: Theme name */
				echo esc_html( sprintf( __( '%s offers a choice of starter packs. A starter pack is a bundle of content and/or plugins that will be automatically imported and set up for you.', 'genesis' ), $genesis_active_theme['Name'] ) );
				?>
				</p>
				<p>
				<strong>
				<?php esc_html_e( 'Click on the images below to learn more about each Starter Pack and choose the pack that best suits your needs.', 'genesis' ); ?>
				</strong>
				<?php esc_html_e( 'None of your existing content will be lost. Find this page again at Genesis → Child Theme Setup.', 'genesis' ); ?>
				</p>
			</div>
			<div class="genesis-onboarding-progress-bar-wrapper">
				<span id="genesis-onboarding-progress-bar"></span>
			</div>

			<div class="genesis-onboarding-starter-packs">
				<?php genesis_onboarding_starter_packs_list(); ?>
			</div>

			<ul class="genesis-onboarding-list">
				<li class="genesis-onboarding-task-dependencies genesis-onboarding-area-hidden">
					<div class="genesis-onboarding-task-steps">
						<div class="genesis-onboarding-step-one"></div>
						<div class="genesis-onboarding-step-two">
							<svg class="genesis-onboarding-list-spinner" viewBox="0 0 50 50" aria-hidden="true">
								<circle class="path" cx="25" cy="25" r="23" fill="none" stroke-width="4"></circle>
							</svg>
						</div>
						<div class="genesis-onboarding-step-three">
							<svg style="width:40px; height:40px;" viewBox="0 0 10 10" aria-hidden="true">
								<circle cx="5" cy="5" r="4.5" style="stroke:#6c8196; stroke-width:0.7; fill:none;"></circle>
								<polyline points="2.7,5 4.2,6.7 7.5,3.6" style="stroke:#6c8196; stroke-width:0.7; stroke-linejoin:round; stroke-linecap:round; fill:none;"></polyline>
							</svg>
						</div>
					</div>

					<h3><?php esc_html_e( 'Recommended plugins', 'genesis' ); ?></h3>
					<p><?php esc_html_e( 'Installing and activating plugins for your starter pack.', 'genesis' ); ?></p>
				</li>

				<li class="genesis-onboarding-task-content genesis-onboarding-area-hidden">
					<div class="genesis-onboarding-task-steps">
						<div class="genesis-onboarding-step-one"></div>
						<div class="genesis-onboarding-step-two">
							<svg class="genesis-onboarding-list-spinner" viewBox="0 0 50 50" aria-hidden="true">
								<circle class="path" cx="25" cy="25" r="23" fill="none" stroke-width="4"></circle>
							</svg>
						</div>
						<div class="genesis-onboarding-step-three">
							<svg style="width:40px; height:40px;" viewBox="0 0 10 10" aria-hidden="true">
								<circle cx="5" cy="5" r="4.5" style="stroke:#6c8196; stroke-width:0.7; fill:none;"></circle>
								<polyline points="2.7,5 4.2,6.7 7.5,3.6" style="stroke:#6c8196; stroke-width:0.7; stroke-linejoin:round; stroke-linecap:round; fill:none;"></polyline>
							</svg>
						</div>
					</div>

					<h3><?php esc_html_e( 'Demo content', 'genesis' ); ?></h3>
					<p>
						<?php
						esc_html_e( 'Adding sample content to make your theme look like the chosen starter pack.', 'genesis' );
						?>
					</p>
				</li>

				<li class="genesis-onboarding-task-final">
					<div class="genesis-onboarding-task-steps">
						<div class="genesis-onboarding-step-one"></div>
						<div class="genesis-onboarding-step-two">
							<svg class="genesis-onboarding-list-spinner" viewBox="0 0 50 50" aria-hidden="true">
								<circle class="path" cx="25" cy="25" r="23" fill="none" stroke-width="4"></circle>
							</svg>
						</div>
						<div class="genesis-onboarding-step-three">
							<svg style="width:40px; height:40px;" viewBox="0 0 10 10" aria-hidden="true">
								<circle cx="5" cy="5" r="4.5" style="stroke:#6c8196; stroke-width:0.7; fill:none;"></circle>
								<polyline points="2.7,5 4.2,6.7 7.5,3.6" style="stroke:#6c8196; stroke-width:0.7; stroke-linejoin:round; stroke-linecap:round; fill:none;"></polyline>
							</svg>
						</div>
					</div>

					<h3><?php esc_html_e( 'All done!', 'genesis' ); ?></h3>
					<p><?php esc_html_e( 'Your starter pack installation is complete! View or edit your homepage using the buttons below.', 'genesis' ); ?></p>

					<a id="genesis-onboarding-view-homepage" class="genesis-onboarding-button genesis-onboarding-button-blue" href="<?php echo esc_url( home_url() ); ?>"><?php esc_html_e( 'View your homepage', 'genesis' ); ?></a>
					<a id="genesis-onboarding-edit-homepage" class="genesis-onboarding-button genesis-onboarding-button-blue" href="#"><?php esc_html_e( 'Edit your homepage', 'genesis' ); ?></a>
				</li>
			</ul>
		</main>

	</div><!-- .genesis-onboarding-page-wrap -->
</div>
