<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Upgrade;

/**
 * Upgrade class. Called when `db_version` Genesis setting is below 3200.
 *
 * @since 3.3.1
 */
class Upgrade_DB_3301 implements Upgrade_DB_Interface {
	/**
	 * Deactivate the Genesis Translations plugin.
	 *
	 * If left active the plugin prevents the same translation functionality
	 * from working in Genesis, because it overrides the translations location.
	 *
	 * @since 3.3.1
	 */
	public function upgrade() {
		deactivate_plugins( '/genesis-translations/genesis-translations.php' );
	}
}
