<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Upgrade;

/**
 * Upgrade class. Called when `db_version` Genesis setting is below 2603.
 *
 * @since 3.1.0
 */
class Upgrade_DB_2603 implements Upgrade_DB_Interface {
	/**
	 * Upgrade method.
	 *
	 * @since 2.6.1
	 * @since 3.1.0 Moved to class method.
	 */
	public function upgrade() {
		$this->unslash_post_meta_scripts();
		$this->unslash_header_footer_scripts();
	}

	/**
	 * Strip slashes from header and body scripts saved as post meta.
	 *
	 * @since 2.6.1
	 * @since 3.1.0 Moved to class method.
	 */
	public function unslash_post_meta_scripts() {
		global $wpdb;

		$header_scripts_posts = $wpdb->get_results( "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = '_genesis_scripts'" );
		$body_scripts_posts   = $wpdb->get_results( "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = '_genesis_scripts_body'" );

		foreach ( $header_scripts_posts as $post ) {
			if ( ! empty( $post->post_id ) ) {
				update_post_meta( $post->post_id, '_genesis_scripts', get_post_meta( $post->post_id, '_genesis_scripts', 1 ) );
			}
		}

		foreach ( $body_scripts_posts as $post ) {
			if ( ! empty( $post->post_id ) ) {
				update_post_meta( $post->post_id, '_genesis_scripts_body', get_post_meta( $post->post_id, '_genesis_scripts_body', 1 ) );
			}
		}
	}

	/**
	 * Strip slashes from header and body scripts saved as post meta.
	 *
	 * @since 2.6.1
	 * @since 3.1.0 Moved to class method.
	 */
	public function unslash_header_footer_scripts() {
		genesis_update_settings(
			[
				'header_scripts' => stripslashes( genesis_get_option( 'header_scripts' ) ),
				'footer_scripts' => stripslashes( genesis_get_option( 'footer_scripts' ) ),
			]
		);
	}
}
