<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

add_action( 'show_user_profile', 'genesis_user_options_fields' );
add_action( 'edit_user_profile', 'genesis_user_options_fields' );
/**
 * Add fields for user permissions for Genesis features to the user edit screen.
 *
 * Checkbox settings are:
 *
 * * Enable Genesis Admin Menu?
 * * Enable SEO Settings Submenu?
 * * Enable Import/Export Submenu?
 *
 * @since 1.4.0
 *
 * @param \WP_User $user User object.
 * @return void Return early if current user can not edit users.
 */
function genesis_user_options_fields( $user ) {

	if ( current_user_can( 'edit_users', $user->ID ) ) {
		genesis_meta_boxes()->show_meta_box( 'genesis-user-settings', $user );
	}

}

add_action( 'show_user_profile', 'genesis_user_archive_fields' );
add_action( 'edit_user_profile', 'genesis_user_archive_fields' );
/**
 * Add fields for author archives contents to the user edit screen.
 *
 * Input / Textarea fields are:
 *
 * * Custom Archive Headline
 * * Custom Description Text
 *
 * Checkbox fields are:
 *
 * * Enable Author Box on this User's Posts?
 * * Enable Author Box on this User's Archives?
 *
 * @since 1.6.0
 *
 * @param \WP_User $user User object.
 * @return void Return early if current user can not edit users.
 */
function genesis_user_archive_fields( $user ) {

	if ( current_user_can( 'edit_users', $user->ID ) ) {
		genesis_meta_boxes()->show_meta_box( 'genesis-user-author', $user );
	}

}

add_action( 'show_user_profile', 'genesis_user_seo_fields' );
add_action( 'edit_user_profile', 'genesis_user_seo_fields' );
/**
 * Add fields for author archive SEO to the user edit screen.
 *
 * Input / Textarea fields are:
 *
 * * Custom Document Title
 * * Meta Description
 * * Meta Keywords
 *
 * Checkbox fields are:
 *
 * * Apply noindex to this archive?
 * * Apply nofollow to this archive?
 * * Apply noarchive to this archive?
 *
 * @since 1.4.0
 *
 * @param \WP_User $user User object.
 * @return void Return early if current user can not edit users.
 */
function genesis_user_seo_fields( $user ) {

	if ( current_user_can( 'edit_users', $user->ID ) ) {
		genesis_meta_boxes()->show_meta_box( 'genesis-user-seo', $user );
	}

}

add_action( 'show_user_profile', 'genesis_user_layout_fields' );
add_action( 'edit_user_profile', 'genesis_user_layout_fields' );
/**
 * Add author archive layout selector to the user edit screen.
 *
 * @since 1.4.0
 *
 * @param \WP_User $user User object.
 *
 * @return void Return early if current theme does not support `genesis-archive-layouts`, or Genesis
 *              does not have multiple layouts, or if current user can not edit users.
 */
function genesis_user_layout_fields( $user ) {

	if ( ! current_theme_supports( 'genesis-archive-layouts' ) || ! genesis_has_multiple_layouts() ) {
		return;
	}

	if ( current_user_can( 'edit_users', $user->ID ) ) {
		genesis_meta_boxes()->show_meta_box( 'genesis-user-layout', $user );
	}

}

add_action( 'personal_options_update', 'genesis_user_meta_save' );
add_action( 'edit_user_profile_update', 'genesis_user_meta_save' );
/**
 * Update user meta when user edit page is saved.
 *
 * @since 1.4.0
 *
 * @param int $user_id User ID.
 * @return void Return early if current user can not edit users, or no meta fields submitted.
 */
function genesis_user_meta_save( $user_id ) {

	if ( ! current_user_can( 'edit_users', $user_id ) ) {
		return;
	}
	// phpcs:ignore WordPress.Security.NonceVerification.Missing -- $_POST['genesis-meta'] is not a nonce field.
	if ( ! isset( $_POST['genesis-meta'] ) || ! is_array( $_POST['genesis-meta'] ) ) {
		return;
	}

	$defaults = [
		'genesis_admin_menu'         => '',
		'genesis_seo_settings_menu'  => '',
		'genesis_import_export_menu' => '',
		'genesis_author_box_single'  => '',
		'genesis_author_box_archive' => '',
		'headline'                   => '',
		'intro_text'                 => '',
		'doctitle'                   => '',
		'meta_description'           => '',
		'meta_keywords'              => '',
		'noindex'                    => '',
		'nofollow'                   => '',
		'noarchive'                  => '',
		'layout'                     => '',
	];

	/**
	 * Filter the user meta defaults array.
	 *
	 * Allows developer to filter the default array of user meta key => value pairs.
	 *
	 * @since 2.1.0
	 *
	 * @param array $defaults Default user meta array.
	 */
	$defaults = apply_filters( 'genesis_user_meta_defaults', $defaults );

	// phpcs:ignore WordPress.Security.NonceVerification.Missing -- $_POST['genesis-meta'] is not a nonce field.
	$meta = wp_parse_args( $_POST['genesis-meta'], $defaults );

	$meta['headline']   = wp_strip_all_tags( $meta['headline'] );
	$meta['intro_text'] = current_user_can( 'unfiltered_html' ) ? $meta['intro_text'] : genesis_formatting_kses( $meta['intro_text'] );

	foreach ( $meta as $key => $value ) {
		update_user_meta( $user_id, $key, $value );
	}

}

add_filter( 'get_the_author_genesis_admin_menu', 'genesis_user_meta_default_on', 10, 2 );
add_filter( 'get_the_author_genesis_seo_settings_menu', 'genesis_user_meta_default_on', 10, 2 );
add_filter( 'get_the_author_genesis_import_export_menu', 'genesis_user_meta_default_on', 10, 2 );
/**
 * Check to see if user data has actually been saved, or if defaults need to be forced.
 *
 * This filter is useful for user options that need to be "on" by default, but keeps us from having to push defaults
 * into the database, which would be a very expensive task.
 *
 * @since 1.4.0
 *
 * @global bool|object authordata User object if successful, false if not.
 *
 * @param string|bool $value   The submitted value.
 * @param int         $user_id User ID.
 * @return mixed|int Submitted value, user field value, or `1`.
 */
function genesis_user_meta_default_on( $value, $user_id ) {

	// If a real value exists, simply return it.
	if ( $value ) {
		return $value;
	}

	// Get the name of the field by removing the prefix from the active filter.
	$field = str_replace( 'get_the_author_', '', current_filter() );

	// Setup user data.
	if ( ! $user_id ) {
		global $authordata;
	} else {
		// phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited -- same pattern used in` get_the_author_meta()
		$authordata = get_userdata( $user_id );
	}

	// Just in case.
	$user_field = "user_$field";
	if ( isset( $authordata->$user_field ) ) {
		return $authordata->user_field;
	}

	// If an empty or false value exists, return it.
	if ( isset( $authordata->$field ) ) {
		return $value;
	}

	// If all that fails, default to true.
	return 1;

}

add_filter( 'get_the_author_genesis_author_box_single', 'genesis_author_box_single_default_on', 10, 2 );
/**
 * Conditionally force a default 1 value for each users' author box setting.
 *
 * @since 1.4.0
 *
 * @param string $value   Submitted value.
 * @param int    $user_id User ID.
 * @return mixed Existing user meta value, or `1`.
 */
function genesis_author_box_single_default_on( $value, $user_id ) {

	if ( genesis_get_option( 'author_box_single' ) ) {
		return genesis_user_meta_default_on( $value, $user_id );
	}

	return $value;

}
