## [3.0.0] - 2019-06-19
### Added
* Added AMP support if the WordPress AMP plugin is installed and active (https://wordpress.org/plugins/amp/). This includes an AMP-compatible, responsive menu that theme developers can add via `genesis_register_responsive_menus()`, in place of having to enqueue their own responsive menu scripts.
* Added `genesis_get_theme_handle()` function that returns a formatted theme handle, via the theme name in `style.css`, for use in places where a string of words (lowercase, separated by dashes) is needed.
* Added `genesis_get_theme_version()` function to return the version string from the stylesheet header, or the current Unix time if the `SCRIPT_DEBUG` constant is true. This is helpful as a cache-busting string when enqueueing assets, so that you no longer need to add a `CHILD_THEME_VERSION` constant to your `functions.php` that duplicates information in your stylesheet header.
* Added memoization to `genesis_get_theme_handle()` and `genesis_get_theme_version()` so multiple uses of these functions won't negatively affect performance.
* Added ability to use the `query_args` custom field to trigger a custom loop in pages (like the old `page_blog.php` used to do).
* Added db upgrade functions that provide for backward compatibility for sites using the `page_blog.php` and `page_archive.php` page templates.
* Added Genesis information to the WordPress Site Health admin page.

### Removed
* Removed Theme and SEO Settings page content. Customizer is now the canonical location for configuring these settings.
* Removed support for all non-html5 output.
* Removed `404.php` template.
* Removed `page.php` template.
* Removed `page_archive.php` template.
* Removed `page_blog.php` template.
* Removed `search.php` template.
* Removed `single.php` template.
* Removed Adsense Auto Ads integration, with limited backward compatibility.
* Removed integration with Google Plus.
* Removed all styles from `style.css`.
* Removed all functions deprecated prior to Genesis 2.0.0.
* Removed compatibility with old and unknown breadcrumb plugins/functions.
* Removed unused `$backtotop` variable and filter from footer output function.
* Deprecated the `genesis_nav_right()` callback function.

### Changed
* Output the responsive viewport meta tag by default.

### Fixed
* Fixed all known instances of content being output without any escaping or sanitization.
* Fixed bug where an empty paragraph was output in the archive intro text.
* Fixed bug in comments where certain markup was appearing out of order.
* Fixed issue where the Genesis Plugins link was showing for people who did not have permission to install plugins.


[3.0.0]: https://github.com/studiopress/genesis/compare/2.10.1...3.0.0
