## 2.0.0 - 2013-08-07
### Added
- Add semantic HTML5 elements across all output.
- Add attributes markup functions `genesis_attr()` and `genesis_parse_attr()`, allowing key elements to have their attributes filtered in.
- Add default microdata that covers itemtypes of WebPage, Blog, SearchResultsPage, WPHeader, WPSideBar, WPFooter, SiteNavigationElement, CreativeWork, BlogPosting, UserComments, and Person, and their corresponding properties.
- Add role attributes to assist with accessibility.
- Add more classes for pagination elements.
- Add HTML5-specific hooks that better match the new semantic structure and be post type agnostic.
- Add HTML5 shiv for Internet Explorer 8 and below.
- Add archive settings for custom post types that are (filterable conditions) public, show a UI, show a menu, have an archive, and support `genesis-cpt-archives-settings`.
- Add contextual help to settings pages, allowing better explanation of settings, and potentially reducing some visual distractions amongst the settings.
- Add distinct admin menu icon, instead of using default favicon.
- Add an unsaved settings alert, when the user is about to navigate away from a settings page after changing a value but not yet saved.
- Add semantic headings setting for using multiple h1 elements on a page.
- Add permalink on posts with no title.
- Add recognition of SEO Ultimate plugin, to enable Genesis SEO to automatically disable.
- Add iframe to CSS to cover responsive video.
- Add new clearfix method for block elements.
- Add `rtl.css` file to automatically display sites set-up as right-to-left language better, and gives theme authors a good starting point.
- Add updated screenshot.
- Add JSLint Closure Compiler instructions to Superfish args non-minified file.
- Add minified JavaScript (`-.min.js`) files that are used by default, unless `SCRIPT_DEBUG` is true.
- Add minified admin style sheet (`-.min.css`) files that are used by default, unless `SCRIPT_DEBUG` is true.
- Add early registration of Superfish files.
- Add header logo files.
- Add `absint` and `safe_html` new settings sanitization types.
- Add sanitization for custom body and post classes.
- Add filter to disable loading of deprecated functions file.
- Add filter to Superfish args URL.
- Add filter to initial layouts.
- Add filters to structural wraps – attributes and output.
- Add ability to wrap markup around output of `genesis_custom_field()`.
- Add two new breadcrumb-related filters, `genesis_build_crumbs` and `genesis_breadcrumb_link`.
- Add `$args` to sidebar defaults filter.
- Add `$footer_widgets` to `genesis_footer_widget_areas` filter.
- Add context arg in `genesis_get_image()` to allow for more control when filtering output.
- Add fallback arg in `genesis_get_image()` to decide what thumbnail to show if a featured image is not set.
- Add array type hints where possible. Methods with the same name in classes extended from WP can't have them, not can methods which accept array or strings arguments.
- Add global displayed IDs variable to track which posts are being shown across any loop.
- Add setting to Featured Post widget to exclude already displayed posts.
- Add third parameter to `shortcode_atts()` to utilize new WordPress 3.6 filter.
- Add network-wide update, to eliminate the need to visit each site to trigger database changes.
- Add blank line at the end of each file for cleaner files and diffs.
- Add some preparatory functions for Theme Customizer (full support not until at least Genesis 2.1)
- Add archive description box markup around search result page heading for consistency.
- Add common class for all archive description boxes.
- Add common class for both Featured widgets.
- Add `widget-title` class next to `widgettitle`.
- Add `lib/functions/breadcrumb.php` for breadcrumb-related functions.

### Changed
- Improve in-post scripts box by moving it to its own box, that won't be hidden when an SEO plugin is active.
- Improve feedback for navigation settings.
- Improve What's New page with new content, and random order of contributors.
- Improve admin styles to work better with MP6 plugin.
- Improve wording for email notification setting.
- Improve labels containing URI to use URL instead.
- Improve widget areas by only showing default content to those who can edit widgets.
- Improve organization of style sheet into a more logical grouping.
- Improve reset styles by switching to `normalize.css`.
- Improve selectors by removing all use of ID selectors in `style.css`, down from 107 in Genesis Framework 1.9.2.
- Improve development speed, by switching to 62.5% (10px) default font-size.
- Improve Google Web Fonts usage by using a protocol-less URL.
- Improve Featured Page and Featured Post widgets to utilize the global `$wp_query` so that `is_main_query()` works correctly against it.
- Improve code that toggles display of extra settings, to allow extra settings to be shown when checkbox is not checked.
- Improve inline settings for Closure Compiler so it uses the latest jQuery externs file (1.8).
- Improve Superfish by updating to the latest version (1.7.4) that supports the version of jQuery that ships with WP 3.6, and has touch event support. Includes back-compat file for arrows support.
- Improve support for languages with multibyte characters by replacing both instances of `substr()` with `mb_substr()`.
- Improve widgets by calling `parent::__construct()` directly when registering widgets.
- Improve output from `get_terms()` by making Genesis term metadata available.
- Improve `genesis_do_noposts()` to be post type agnostic.
- Improve `genesis_do_noposts()` to use consistent entry markup.
- Improve admin metabox abstraction so that it hooks in the previously hard-coded metabox container markup.
- Improve import feature to only import Genesis-related settings.
- Improve multi-page navigation code, by moving it out of post content function into its own hooked in function.
- Improve menus by not showing empty markup if there are no menu items.
- Improve unpaged comment navigation by not showing empty markup.
- Improve filtering of terms, by doing nothing if term variable is not an object.
- Improve `genesis_get_custom_field()` by allowing custom fields to return as arrays.
- Improve checkbox inputs to utilize WP admin styling, by wrapping label element around them.
- Improve the organization of the `lib/structure/header.php` file.
- Improve JavaScript classes, by adding `js-` prefix to them.
- Improve breadcrumbs class to refactor large methods into several smaller ones.
- Improve default sidebar contents by refactoring it into a single re-usable function.
- Improve `genesis_search_form()` escaping and logic.
- Improve check for presence of Header Right sidebar before displaying markup.
- Improve internationalization so that menu location names are translatable, by moving loading of text domain earlier.
- Improve internationalization by simplifying strings.
- Improve README file by changing it from a `.txt` to `.md` file.
- Improve single line comment format to be consistent, allowing easier block-commenting around and from the single line comment.
- Improve overall code by using identity comparisons wherever suitable.
- Improve inline documentation throughout.

### Removed
- Remove display of `entry-footer` for everything except posts.
- Remove loading of Superfish script by default. Can be added back by filtering `genesis_superfish_enabled` to be true, or use Genesis Fancy Dropdowns.
- Remove Microformat classes such as hentry.
- Remove global `$loop_counter` since `$wp_query->current_post` does the same job.
- Remove back to top text.
- Remove custom comment form arguments, resulting in default "Leave your Reply" and "You may use these HTML tags and attributes…" showing.
- Remove Fancy Dropdown settings for each menu in favour of more explicit Load Superfish Script setting.
- Remove the now empty Secondary Navigation settings, and which just leaves Primary Navigation Extras.
- Remove Theme Information setting, since parent and child theme information is publicly available in the style sheets.
- Remove child theme README admin menu item.
- Remove RSS and Twitter images.
- Remove device-specific subheadings.
- Remove support for five-column layout.
- Remove previously deprecated eNews widget. Use Genesis eNews Extended plugin as an enhanced replacement.
- Remove previously deprecated Latest Tweets widget. Use Genesis Latest Tweets plugin, or official Twitter widget.
- Remove ternary part of `genesis.confirm()` JavaScript function.
- Remove (deprecated) `genesis_show_theme_info_in_head()`.
- Remove (deprecated) `genesis_theme_files_to_edit()`.
- Remove (deprecated) `g_ent()`.
- Remove (deprecated) `genesis_tweet_linkify()`.
- Remove (deprecated) `genesis_custom_header_admin_style()`.
- Remove (deprecated) `genesis_older_newer_posts_nav()`.
- Remove `GENESIS_LANGUAGES_URL` constant.
- Remove redundant calls and globals from various functions.
- Remove redundant escaping on in-post meta boxes save.
- Remove post templates functionality. Use Single Post Template plugin as a replacement.
- Remove all remaining style attributes.
- Remove all but two of the remaining inline event handlers (on- attributes). Only `onfocus` and `onblur` remain on the XHTML search form in lieu of no placeholder attribute support.
- Remove closing element HTML comments.
- Remove empty files and a directory.
- Remove the Older Posts / Newer Posts archive pagination format in favour of existing Next Page / Previous Page.

### Fixed
- Fix mis-alignment of settings page boxes.
- Fix inconsistent term meta user interface.
- Fix Closure Compiler output file name for `admin.js`.
- Fix `wp_footer()` so it fires right before `</body>`, now after `genesis_after` hook.
- Fix duplicate IDs on top and bottom submit and reset admin buttons.
- Fix invalid HTML output in user profile widget.
- Fix duplicate calls to `genesis_no_comments_text` filter.
- Fix structural wrap function so support for them can be removed completely.
- Fix incorrectly linked label on noarchive post setting.
- Fix out-of-date Theme and SEO Settings defaults and sanitising.
- Fix redundant parameter in `genesis_save_custom_fields()`.
- Fix breadcrumb issue for date archives.
