## 1.8.0 - 2012-01-20
### Added
- Add new color scheme / style metabox on Theme Settings page which child themes can use instead of building their own.
- Add setting to enable / disable breadcrumbs on attachment pages.
- Add Genesis features to post and page editors via post type support, instead of hard-coding – you can now disable the inpost metaboxes by removing post type support with a single line of code.
- Add separate custom title and description on term archives (displayed content defaults to existing title and description if not customized further).
- Add vendor-prefixed border-radius properties.
- Add posts-link class to user profile widget to accompany the now deprecated `posts_link` class.
- Add extended page link text setting for the user profile widget. No longer hard-coded as `[Read more…]`.
- Add warning to Genesis Page and Category Menu widget descriptions, to gently deprecate them (use WP Custom Menu widget instead).
- Add `Genesis_Admin` classes – a set of 1+3 abstract classes from which all Genesis admin pages now extend from.
- Add `genesis_is_menu_page()` helper function to check we're targeting a specific admin page.
- Add new `genesis_widget_area()` helper function for use in child themes.
- Add `author` value to `rel` attribute for author link shortcode functions.
- Add argument to `genesis_get_option()` and others to not use the Genesis cache.
- Add ability to make nav menu support conditional.
- Add search form label filter, so themes can add a visual label in if they wish.
- Add filter to disable edit post / page link.
- Add filter to Content Archives display types.
- Add filter to the options sent to `wp_remote_post()` when doing an update check.
- Add filter on custom header defaults.
- Add filters for term meta.
- Add filters for previous and next links text.
- Add `genesis_formatting_kses()` to be used as a filter function.
- Add crop parameter to return value of `genesis_get_image_sizes()`.
- Add a complete overhaul of DocBlock documentation at the page-, class-, method- and function-level. See an example of the generated documentation for Genesis 1.8.0. Comment lines now make up over 40% of all lines of code in Genesis 1.8.0, up from 30% in Genesis 1.6, with a significant amount of non-comment code having been added in the meantime as well.

### Changed
- Improve admin labels by reducing conspicuousness (basically, removing "Genesis" from several headings also displayed on wordpress.com installs).
- Improve image dimensions dropdown to use correct multiplication character, not the letter x.
- Improve label relationships with the `for` attribute to make them explicitly linked as per accessibility best practices.
- Improve top buttons to work better with non-English languages.
- Improve metabox order on Theme Settings page.
- Improve specific case CSS for input buttons with more generic selectors.
- Improve styles for new default Genesis appearance, including responsive design.
- Improve classes used for menus to be more consistent with WP, and allow simpler selectors. See [Brian's post](http://www.briangardner.com/genesis-customize-menus/) for more info.
- Improve eNews widget to now pass WP locale to Feedburner, instead of hard-coded `en_US`.
- Improve "Header Right" widget area to display as "Header Left" if right-to-left language is used.
- Improve the image alignment option "None" by giving it a value of alignnone in featured post and page widgets.
- Improve user profile author dropdown to only show actual authors, not all users.
- Improve `admin.js` with a complete rewrite to separate functions from events, make functions re-usable under genesis namespace, switch to using `on()` method for jQuery 1.7.1 and ensure all event bindings are namespaced.
- Improve ability to amend togglable settings by moving the config to PHP where they can be more easily filtered, before sending to JavaScript.
- Improve admin scripts to only appear on the appropriate admin pages.
- Improve submit button markup by using `submit_button()` instead of hard-coding it.
- Improve structural wrap usage.
- Improve `genesis_layout_selector()` by allowing layout options to be shown by type.
- Improve code quality by refactoring widget defaults into the constructor to avoid duplication.
- Improve some functions to return earlier if conditions aren't correct.
- Improve `genesis_strip_attr()` to accept a string for the elements arguments.
- Improve featured post widget performance by sanitizing byline with KSES on save, not output.
- Improve taxonomy term performance by sanitizing description on save, not output.
- Improve `comment_form()` by passing filterable comment form args.
- Improve `genesis_admin_redirect()` by eliminating multiple calls to `add_query_arg()`.
- Improve order of the notice checks to avoid the reset notice still showing after saving settings.
- Improve `genesis_custom_loop()` by refactoring it to use `genesis_standard_loop()`.
- Improve updates procedure by ensuring a fresh request for database options at each incremental stage.
- Improve notice to actually check if settings save was actually sucessfull or not.
- Improve custom post type (custom post type) archive breadcrumb by only linking if custom post type has an archive.
- Improve post date title attribute for hEntry by using HTML5-compatible format.
- Improve `_genesis_update_settings()` by moving it to the correct file.
- Improve code organization by moving general sanitization functions to the sanitization file from theme settings file.
- Improve code organization by moving per-page sanitization code to the related admin page class.
- Improve theme screenshot.
- Improve favicon.
- Improve default footer wording credits.
- Improve readme content with Header Right info.
- Improve `.pot` file with additional and corrected headers and updated to 381 strings in total.
- Improve documentation by moving warning message in top-level files to outside of docblocks so they don't count as short descriptions.
- Improve code so it is now written to WordPress Code Standards, programatically testable via WordPress Code Sniffs.
- Improve translation of strings by extracting `<code>` bits to simplify them and reduce the number of unique strings to translate.

### Removed
- Remove settings form from Genesis Page and Category Menu widgets, to further deprecate them.
- Remove now-deprecated functions from `lib/functions/admin.php` and deprecated file.
- Remove duplicated custom post class handling code.
- Remove (deprecated) `genesis_filter_attachment_image_attributes()` function as WP has since improved.
- Remove `genesis_load_styles()` as it was an empty function that was never used.
- Remove remaining PHP4-compatible class constructor names in favour of `__construct()`.
- Remove unnecessary check for WordPress SEO plugin to re-enable title and description output on term archive pages when WordPress SEO is active.
- Remove SEO options that remove some of the relationship link tags from the head. See [\[18680\]](http://core.trac.wordpress.org/changeset/18680) for more info.

### Fixed
- Fix appearance of layout selector for IE8 users.
- Fix issue with incorrect CSS being output for custom header text color.
- Fix issue with new WP install default widgets appearing in Header Right widget area when switching themes.
- Fix escaping of some values in theme settings.
- Fix rare `add_query_arg()` bug by not passing it an encoded URL.
- Fix issue with duplicate canonical tags in the head when an SEO plugin is active.
- Fix missing second and third parameters when applying the `widget_title filter`.
- Fix empty anchor in `post_author_posts_link` shortcode function.
- Fix clash with grid loop features and features taxonomy (as in AgentPress Listings plugin).
- Fix variable name under which JavaScript strings are localized, from `genesis` to `genesisL10n` to be consistent with WordPress practices.
- Fix license compatibility for child themes by changing license from "GPLv2" to "GPLv2 (or later)".
- Fix missing text-domain for footer widget area description, post author link shortcode, and user profile widget.
- Fix the Scribe notice to be translatable.
