<?php

use eightball\ContentClass;

add_filter('genesis_post_info', '__return_empty_string');
remove_action('genesis_entry_footer', 'genesis_post_meta');

// Banner
add_action('genesis_after_header', 'cs_blog_banner', 999);
function cs_blog_banner()
{
    $singleBlogBanner = new SingleBlogBanner();
    $singleBlogBanner->contentWrapper();
}

// Content
class SingleBlogBanner extends ContentClass
{
    protected static $containerClassName = 'eightball-block__single-post-banner';
    protected static $contentInsideContainer = false;

    protected function createLayout()
    {
        ?>
        <div class="container-fluid single-post__container">
            <div class="row">
                <div class="offset-xxl-2 col-xxl-8 offset-lg-1 col-lg-10 col-12">
                    <div class="row single-post__top">
                        <div class="col-lg-6 single-post__left">
                            <div class="site-banner__post-cats">
                                <?php echo get_the_category_list('<span>,</span> ', ''); ?>
                            </div>

                            <h1>
                                <?php the_title(); ?>
                            </h1>

                            <?php if (get_field('time_to_read')): ?>
                                <p>
                                    <?= get_field('time_to_read') ?> Minutes Read
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

add_action('genesis_before_footer', 'cs_do_footer');
function cs_do_footer()
{
    $singleBlogFooter = new SingleBlogFooter();
    $singleBlogFooter->contentWrapper();
}

class SingleBlogFooter extends ContentClass
{
    protected static $containerClassName = 'eightball-block__blog-footer-block';
    protected static $contentInsideContainer = false;
    protected static $settings = 'blog_archive_footer_settings';
    protected static $options = true;

    protected function createLayout()
    {
        $main_title = get_field('main_title', 'option');
        $description = get_field('description', 'option');
        $form_shortcode = get_field('blog_form_shortcode', 'option');
        $footer_menu = get_field('footer_menu', 'option');
        $logo = get_field('logo', 'option');
        $social_media_links = get_field('social_media_links', 'options');
        ?>
        <div class="container-fluid archive-post__footer">
            <div class="row">
                <div class="offset-xxl-2 col-xxl-8 offset-lg-1 col-lg-10 col-12">
                    <div class="row">
                        <div class="col-xl-5 col-lg-6">
                            <?php if ($main_title): ?>
                                <h3 class="h1 <?= static::$containerClassName ?>__main-title">
                                    <?= $main_title ?>
                                </h3>

                                <hr>
                            <?php endif; ?>

                            <?php if ($description): ?>
                                <p class="intro-text <?= static::$containerClassName ?>__desc">
                                    <?= $description ?>
                                </p>
                            <?php endif; ?>

                        </div>

                        <div class="col-xl-4 col-lg-6 <?= static::$containerClassName ?>__middle">
                            <?php
                            if ($form_shortcode):
                                echo do_shortcode($form_shortcode);
                            endif;
                            ?>
                        </div>

                        <div class="col-xl-3 col-lg-12 <?= static::$containerClassName ?>__right">
                            <?php if ($footer_menu): ?>
                                <div class=" <?= static::$containerClassName ?>__menu">
                                    <?php foreach ($footer_menu as $menu): ?>
                                        <a href="">
                                            <?= $menu['link']['title'] ?>
                                        </a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <div class="<?= static::$containerClassName ?>__right__logo">
                                <?php
                                if ($logo):
                                    echo wp_get_attachment_image($logo['id'], 'full');
                                endif;

                                if ($social_media_links):
                                    ?>
                                    <div class=" <?= static::$containerClassName ?>__social-menu">
                                        <?php foreach ($social_media_links as $link): ?>
                                            <a href="<?= $link['link'] ?>" target="_blank">
                                                <?= $link['icon'] ?>
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
genesis();