<?php


// Starts the engine.
require_once get_template_directory() . '/lib/init.php';

// Registers the responsive menus.
if ( function_exists( 'genesis_register_responsive_menus' ) ) {
    genesis_register_responsive_menus( genesis_get_config( 'responsive-menus' ) );
}

add_action( 'wp_enqueue_scripts', 'genesis_sample_enqueue_scripts_styles' );
function genesis_sample_enqueue_scripts_styles() {
    wp_enqueue_style( 'dashicons' );
}

add_action( 'after_setup_theme', 'genesis_sample_theme_support', 9 );
function genesis_sample_theme_support() {
    $theme_supports = genesis_get_config( 'theme-supports' );
    foreach ( $theme_supports as $feature => $args ) {
        add_theme_support( $feature, $args );
    }
}

// Removes header right widget area.
unregister_sidebar( 'header-right' );

// Removes secondary sidebar.
unregister_sidebar( 'sidebar-alt' );

// Repositions primary navigation menu.
remove_action( 'genesis_after_header', 'genesis_do_nav' );
//add_action( 'genesis_header', 'genesis_do_nav', 12 );

// Repositions the secondary navigation menu.
remove_action( 'genesis_after_header', 'genesis_do_subnav' );
//add_action( 'genesis_footer', 'genesis_do_subnav', 10 );

remove_action( 'genesis_footer', 'genesis_do_footer' );

add_filter( 'wp_nav_menu_args', 'genesis_sample_secondary_menu_args' );
function genesis_sample_secondary_menu_args( $args ) {
    if ( 'secondary' === $args[ 'theme_location' ] ) {
        $args[ 'depth' ] = 1;
    }
    return $args;
}

add_filter( 'genesis_author_box_gravatar_size', 'genesis_sample_author_box_gravatar' );
function genesis_sample_author_box_gravatar( $size ) {
    return 90;
}

add_filter( 'genesis_comment_list_args', 'genesis_sample_comments_gravatar' );
function genesis_sample_comments_gravatar( $args ) {
    $args[ 'avatar_size' ] = 60;
    return $args;
}

// Unregister widgets
add_action( 'widgets_init', 'unregister_genesis_widgets', 20 );
function unregister_genesis_widgets() {
    unregister_widget( 'Genesis_eNews_Updates' );
    unregister_widget( 'Genesis_Featured_Page' );
    unregister_widget( 'Genesis_Featured_Post' );
    unregister_widget( 'Genesis_Latest_Tweets_Widget' );
    unregister_widget( 'Genesis_Menu_Pages_Widget' );
    unregister_widget( 'Genesis_User_Profile_Widget' );
    unregister_widget( 'Genesis_Widget_Menu_Categories' );
}

// remove unnecessary admin menus
remove_theme_support( 'genesis-seo-settings-menu' );
remove_action( 'admin_menu', 'genesis_add_inpost_seo_box' );
remove_action( 'admin_menu', 'genesis_add_inpost_scripts_box' );
add_action( 'admin_menu', 'eightball_remove_genesis_plugins_admin_page', 99 );
function eightball_remove_genesis_plugins_admin_page() {
    remove_submenu_page( 'genesis', 'genesis-plugins' );
}

// Remove page title from pages
remove_action( 'genesis_entry_header', 'genesis_do_post_title' );
remove_action( 'genesis_entry_header', 'genesis_entry_header_markup_open', 5 );
remove_action( 'genesis_entry_header', 'genesis_entry_header_markup_close', 15 );


//* Remove Genesis menu link
remove_theme_support( 'genesis-admin-menu' );


add_filter ( 'genesis_edit_post_link' , '__return_false' );
