<?php

namespace eightball;

abstract class ContentClass
{
    protected static $settings = '';
    protected static $containerClassName = '';
    protected static $rowClassName = '';
    protected static $colClassName = '';
    protected static $contentInsideContainer = true;
    protected static $options = false;

    abstract protected function createLayout();

    protected static function layoutSettings()
    {
        (static::$options) ? $layoutSettings = get_field(static::$settings, 'options') : $layoutSettings = get_field(static::$settings);
        return $layoutSettings;
    }

    protected function echoTopLayoutPadding()
    {
        if (!empty(static::layoutSettings()['block_top_padding'])) {
            echo ' eightball-block__padding-top--' . static::layoutSettings()['block_top_padding'];
        }

        return null;
    }

    protected function echoBottomLayoutPadding()
    {
        if (!empty(static::layoutSettings()['block_bottom_padding'])) {
            echo ' eightball-block__padding-bottom--' . static::layoutSettings()['block_bottom_padding'];
        }

        return null;
    }

    protected function echoTopLayoutMargin()
    {
        if (!empty(static::layoutSettings()['block_top_margin'])) {
            echo ' eightball-block__margin-top--' . static::layoutSettings()['block_top_margin'];
        }

        return null;
    }

    protected function echoBottomLayoutMargin()
    {
        if (!empty(static::layoutSettings()['block_bottom_margin'])) {
            echo ' eightball-block__margin-bottom--' . static::layoutSettings()['block_bottom_margin'];
        }

        return null;
    }

    protected function echoLayoutWidth()
    {
        if (static::$contentInsideContainer) {
            if (!empty(static::layoutSettings()['block_width'])) {
                if (static::layoutSettings()['block_width'] === 'max-width') {
                    echo 'container ';
                } else {
                    echo 'container-fluid ';
                }
            }
        }

        echo '';
    }

    protected function echoLayout()
    {
        $col_width = static::$colClassName;

        $block_width = isset(static::layoutSettings()['block_content_width']) ? static::layoutSettings()['block_content_width'] : null;

        switch ($block_width) {
            case 'x-large':
                $col_width .= ' offset-xxxl-1 col-xxxl-10 ';
                break;
            case 'large':
                $col_width .= ' offset-xxxl-2 col-xxxl-8 offset-lg-1 col-lg-10 ';
                break;
            case 'medium':
                $col_width .= ' offset-xxxl-3 col-xxxl-6 offset-lg-2 col-lg-8 offset-md-1 col-md-10 ';
                break;
            case 'small':
                $col_width .= ' offset-xxxl-4 col-xxxl-4 offset-xl-3 col-xl-6 offset-lg-2 col-lg-8 offset-md-1 col-md-10 ';
                break;
//            case 'x-small':
//                $col_width .= ' offset-xxxl-4 col-xxxl-4 offset-xl-3 col-xl-6 offset-lg-2 col-lg-8 offset-md-1 col-md-10 ';
//                break;
        }

        $styles = $this->addContentBgImage();
        $styles_layout = '';
        if ($styles != null) {
            $styles_layout = 'style="background-image: url(' . $styles . '); background-size:cover;background-repeat:no-repeat;background-position:center"';
        }

        if (static::$contentInsideContainer) {
            ?>
            <div class="<?= $col_width ?>col-12" <?= $styles_layout ?>>
                <?php echo $this->createLayout(); ?>
            </div>
            <?php
        } else {
            echo $this->createLayout();
        }
    }

    protected function extraClassNames()
    {
        if (isset(static::layoutSettings()['extra_classnames'])) {
            echo ' ' . static::layoutSettings()['extra_classnames'];
        }

        return '';
    }

    protected function generateClassNames()
    {

        $classNames = (static::$containerClassName === '') ? ' eightball-block ' : ' eightball-block ' . static::$containerClassName . $this->echoTopLayoutPadding() . $this->echoBottomLayoutPadding() . $this->echoTopLayoutMargin() . $this->echoBottomLayoutMargin() . $this->extraClassNames();;

        $mobile = isset(static::layoutSettings()['hide_block_on_mobile']) ? static::layoutSettings()['hide_block_on_mobile'] : null;

        $red_bg = isset(static::layoutSettings()['has_curved_bottom']) ? static::layoutSettings()['has_curved_bottom'] : null;

        if ($mobile) {
            if (wp_is_mobile()) {
                $classNames .= ' hide-on-mobile';
            }
        }

        if ($red_bg != '') {
            $classNames .= ' has-curved-bottom';
        }

        echo $classNames;
    }

    protected function addBgImage()
    {
        if (wp_is_mobile() && static::layoutSettings()['block_background_image_mobile']) {
            return static::layoutSettings()['block_background_image_mobile']['url'];
        } elseif (!empty(static::layoutSettings()['block_background_image'])) {
            return static::layoutSettings()['block_background_image']['sizes']['banner-size'];
        } else {
            return null;
        }
    }

    protected function addBgColour()
    {
        if (!empty(static::layoutSettings()['block_background_colour'])) return static::layoutSettings()['block_background_colour'];
        return null;
    }

    protected function addContentColour()
    {
        if (!empty(static::layoutSettings()['block_content_colour'])) return static::layoutSettings()['block_content_colour'];
        return null;
    }

    protected function bgImagePosition()
    {
        if (!empty(static::layoutSettings()['block_background_image_position'])) return static::layoutSettings()['block_background_image_position'];
        return null;
    }

    protected function bgImageSize()
    {
        if (!empty(static::layoutSettings()['block_background_image_size'])) return static::layoutSettings()['block_background_image_size'];
        return null;
    }

    protected function sectionID()
    {
        if (!empty(static::layoutSettings()['section_id'])) return static::layoutSettings()['section_id'];
        return 'eightball-block__' . rand(9999, 19999);
    }

    protected function addContentBgImage()
    {
        if (wp_is_mobile() && static::layoutSettings()['block_content_background_image_mobile']) {
            return static::layoutSettings()['block_content_background_image_mobile']['url'];
        } elseif (!empty(static::layoutSettings()['block_content_background_image'])) {
            return static::layoutSettings()['block_content_background_image']['sizes']['banner-size'];
        } else {
            return null;
        }
    }

    protected function addStyles()
    {
        $styles = 'style="';

        if ($this->addBgImage() !== null) {
            $styles .= "background-image: url('" . $this->addBgImage() . "'); ";
        }

        if ($this->bgImageSize() !== null) {
            $styles .= 'background-size: ' . $this->bgImageSize() . ';';
        }

        if ($this->bgImagePosition() !== null) {
            $styles .= 'background-position: ' . $this->bgImagePosition() . ';';
        }

        if ($this->addBgColour() !== null) {
            $styles .= 'background-color: ' . $this->addBgColour() . ';';
        }

        if ($this->addContentColour() !== null) {
            $styles .= 'color: ' . $this->addContentColour() . ';';
        }

        $styles .= '"';

        echo $styles;
    }

    protected function generateRowClassNames()
    {
        $classNames = static::$rowClassName;
        echo $classNames;
    }

    protected function generatedID()
    {
        if ($this->sectionID() !== null) {
            echo 'id= "' . $this->sectionID() . '" ';
        }
    }

    protected function blockBackgroundColour()
    {
        if (!empty(static::layoutSettings()['block_content_background_colour'])) return static::layoutSettings()['block_content_background_colour'];
        return null;
    }

    protected function addBlockBackgroundColour()
    {
        if ($this->blockBackgroundColour() !== null) {
            echo 'style="background-color: ' . $this->blockBackgroundColour() . '"';
        }

        return null;
    }

    protected function hasCurvedBottom()
    {
        if (static::layoutSettings()['block_background_colour'] && static::layoutSettings()['has_curved_bottom']) {
            $bg_color = static::layoutSettings()['block_background_colour'];
            $id = static::sectionID();
            ?>
            <span class="has-curved-bottom__span">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1926.74 268.23"><defs><style>.cls-1-<?= $id ?>{fill:<?= $bg_color ?>;}</style></defs><g id="Layer_2" data-name="Layer 2"><g id="who_we_are" data-name="who we are"><path class="cls-1-<?= $id ?>" d="M1923.84,154.75s-602.25,110.3-927,113.36S289,212.17,224.93,207.57,23.64,173.13,0,176.2V0H1925.24S1929.4,160.32,1923.84,154.75Z"/></g></g></svg>
            </span>
            <?php
        }

        return null;
    }

    protected function hasCurvedTop()
    {
        if (static::layoutSettings()['block_background_colour'] && static::layoutSettings()['has_curved_top']) {
            $bg_color = static::layoutSettings()['block_background_colour'];
            $id = static::sectionID();
            ?>
            <span class="has-curved-top__span">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1940.43 488.63"><defs><style>.a-<?= $id ?>{fill:<?= $bg_color ?>;}</style></defs><path class="a-<?= $id ?>" d="M1932.57,0C1584.89,56.78,1198.71,108.83,818.2,102.64,224.68,93,0,13.79,0,13.79V488.63H1940.43Z"/></svg>
            </span>
            <?php
        }

        return null;
    }

    public function contentWrapper()
    {
        ?>
        <section <?php $this->generatedID() ?>
                class="<?php $this->generateClassNames(); ?>" <?php $this->addStyles() ?>>
            <?php if (static::$contentInsideContainer): ?>
                <div class="container-fluid" <?php $this->addBlockBackgroundColour() ?>>
                    <div class="row <?php $this->generateRowClassNames(); ?>">
                        <?php $this->echoLayout() ?>
                    </div>
                </div>
            <?php else: ?>
                <?php $this->echoLayout() ?>
            <?php endif; ?>
        </section>
        <?php
    }

    public function __constructor()
    {
        $this->contentWrapper();
    }
}