<?php

// Add support for wide blocks
add_theme_support( 'align-wide' );

add_filter( 'allowed_block_types', 'eightball_allowed_block_types' );
function eightball_allowed_block_types( $allowed_blocks ) {

    return array(
        'acf/basic-content-block',
        'acf/two-column-layout',
        'acf/main-footer-block',
        'acf/home-banner-block',
        'acf/heading-featured-list',
        'acf/faqs-block',
        'acf/contact-block',
        'acf/alt-footer-block',
        'acf/image-repeater-block',
        'acf/our-reviews-block'
    );

}

// ACF Blocks
add_action( 'acf/init', 'eightball_acf_init_block_types' );
function eightball_acf_init_block_types() {
    if ( function_exists( 'acf_register_block_type' ) ) {

        acf_register_block_type( array(
            'name' => 'basic-content-block',
            'title' => __( 'Basic Content Block' ),
            'description' => __( 'Regular WYSIWYG Editor' ),
            'render_template' => 'blocks/BasicContentBlock.php',
            'category' => 'generic-layouts',
            'icon' => 'text',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'two-column-layout',
            'title' => __( 'Two Column Block' ),
            'description' => __( 'Two Column Block' ),
            'render_template' => 'blocks/TwoColumnLayout.php',
            'category' => 'generic-layouts',
            'icon' => 'columns',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'main-footer-block',
            'title' => __( 'Main Footer Block' ),
            'description' => __( 'Main Footer Block' ),
            'render_template' => 'blocks/MainFooterBlock.php',
            'category' => 'footer-layouts',
            'icon' => 'align-full-width',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'home-banner-block',
            'title' => __( 'Page Banner Block' ),
            'description' => __( 'Page Banner Block' ),
            'render_template' => 'blocks/HomePageBannerBlock.php',
            'category' => 'generic-layouts',
            'icon' => 'admin-page',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'heading-featured-list',
            'title' => __( 'Heading and Featured List' ),
            'description' => __( 'Heading and Featured List' ),
            'render_template' => 'blocks/HeadingFeaturedList.php',
            'category' => 'generic-layouts',
            'icon' => 'heading',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
                wp_enqueue_style( 'swiper' );
                wp_enqueue_script( 'swiper' );
                wp_enqueue_script( 'heading-featured-list' );
            }
        ) );

        acf_register_block_type( array(
            'name' => 'faqs-block',
            'title' => __( 'FAQs Block' ),
            'description' => __( 'FAQs Block' ),
            'render_template' => 'blocks/FAQsBlock.php',
            'category' => 'generic-layouts',
            'icon' => 'search',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
                wp_enqueue_script( 'faqs' );
            }
        ) );

        acf_register_block_type( array(
            'name' => 'contact-block',
            'title' => __( 'Contact Block' ),
            'description' => __( 'Contact Block' ),
            'render_template' => 'blocks/ContactUsBlock.php',
            'category' => 'generic-layouts',
            'icon' => 'admin-users',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'alt-footer-block',
            'title' => __( 'Alt Footer Block' ),
            'description' => __( 'Alt Footer Block' ),
            'render_template' => 'blocks/AltFooterBlock.php',
            'category' => 'footer-layouts',
            'icon' => 'admin-appearance',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'image-repeater-block',
            'title' => __( 'Image Repeater Block' ),
            'description' => __( 'Image Repeater Block' ),
            'render_template' => 'blocks/ImageRepeaterBlock.php',
            'category' => 'generic-layouts',
            'icon' => 'images-alt',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
            }
        ) );

        acf_register_block_type( array(
            'name' => 'our-reviews-block',
            'title' => __( 'Our Reviews Block' ),
            'description' => __( 'Our Reviews Block' ),
            'render_template' => 'blocks/OurReviewsBlock.php',
            'category' => 'generic-layouts',
            'icon' => 'format-quote',
            'supports' => [
                'align' => false,
            ],
            'enqueue_assets' => function () {
                wp_enqueue_script( 'reviews' );
            }
        ) );
    }
}


// Add Custom Block Cats
add_filter( 'block_categories_all', 'eightball_add_new_block_category' );
function eightball_add_new_block_category( $block_categories ) {
    array_push( $block_categories,
        [
            'slug' => 'generic-layouts',
            'title' => esc_html__( 'Generic Layouts', 'text-domain' ),
            'icon' => 'layout',
        ],
        [
            'slug' => 'footer-layouts',
            'title' => esc_html__( 'Footer Layouts', 'text-domain' ),
            'icon' => 'button',
        ]
    );

    return $block_categories;
}
