<?php

use eightball\ContentClass;

// Remove main loop
remove_action( 'genesis_loop', 'genesis_do_loop' );
remove_action( 'genesis_before_loop', 'genesis_do_posts_page_heading' );
remove_action( 'genesis_before_loop', 'genesis_do_taxonomy_title_description', 15 );

// Banner
add_action( 'genesis_after_header', 'cs_blog_banner', 999 );
function cs_blog_banner() {
    $blogBanner = new BlogBanner();
    $blogBanner->contentWrapper();
}

add_action( 'genesis_loop', 'cs_do_loop' );
function cs_do_loop() {
    ?>
    <div class="container-fluid archive-post__container">
        <div class="row">
            <div class="offset-xxl-2 col-xxl-8 offset-lg-1 col-lg-10 col-12">
                <div class="row">
                    <?php
                    if ( have_posts() ) :
                        while ( have_posts() ) : the_post();
                            ?>
                            <div class="col-xl-4 col-lg-6 archive-post__col col-12">
                                <a class="archive-post__image" href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'medium_large' ); ?>
                                </a>

                                <h2 class="h5 archive-post__title">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title() ?>
                                    </a>
                                </h2>

                                <p class="archive-post__excerpt">
                                    <?php cs_excerpt( 24 ) ?>
                                </p>

                                <a class="cs-button__reg__red" href="<?php the_permalink(); ?>">
                                    Read More
                                </a>
                            </div>
                        <?php
                        endwhile;
                        the_posts_pagination( [
                            'next_text' => '<i class="fas fa-caret-right"></i>',
                            'prev_text' => '<i class="fas fa-caret-left"></i>'
                        ] );
                    else :
                        ?>
                        <div class="col-12">
                            <h3>
                                Sorry, no posts were found.
                            </h3>
                        </div>
                    <?php
                    endif;
                    ?>
                </div>
            </div>

        </div>
    </div>
    <?php
}

add_action( 'genesis_before_footer', 'cs_do_footer' );
function cs_do_footer() {
    $blogFooter = new BlogFooter();
    $blogFooter->contentWrapper();
}


// Content
class BlogBanner extends ContentClass
{
    protected static $containerClassName = 'eightball-block__blog-banner-block';
    protected static $contentInsideContainer = false;

    protected function createLayout() {
        $image = get_field( 'image', 'option' );
        $content = get_field( 'content', 'option' );
        ?>
        <div class="container-fluid archive-post__container">
            <div class="row">
                <div class="offset-xxl-2 col-xxl-8 offset-lg-1 col-lg-10 col-12">
                    <div class="row <?= static::$containerClassName ?>__top">
                        <div class="col-lg-6 <?= static::$containerClassName ?>__left">
                            <div class="<?= static::$containerClassName ?>__content">
                                <?php
                                if ( is_home() && $content ):
                                    echo $content;
                                elseif ( is_category() ):
                                    echo '<h1>' . single_cat_title( '', false ) . '</h1>';
                                endif;
                                ?>

                                <div class="<?= static::$containerClassName ?>__categories">
                                    <?php

                                    $categories = get_categories( array(
                                        'orderby' => 'name',
                                        'parent' => 0
                                    ) );

                                    $current_cat = get_queried_object()->slug;

                                    if ( !empty( $current_cat ) ) {
                                        $current_cat = ( strpos( $_SERVER[ 'REQUEST_URI' ], $current_cat ) != false ) ? $current_cat : '';
                                    }

                                    ?>

                                    <a href="<?= get_permalink( get_option( 'page_for_posts' ) ) ?>"
                                       class="<?= ( $current_cat ? '' : 'active' ) ?>">
                                        All
                                    </a>

                                    <?php

                                    foreach ( $categories as $category ) {
                                        ?>
                                        <a href="<?= get_category_link( $category->cat_ID ) ?>"
                                           class="<?= ( ( $category->slug ) == $current_cat ? 'active' : '' ) ?>">
                                            <?= $category->name ?>
                                        </a>
                                        <?php
                                    }

                                    ?>
                                </div>
                            </div>
                        </div>

                        <?php if ( is_home() ): ?>
                            <div class="col-lg-6 <?= static::$containerClassName ?>__right">
                                <div class="<?= static::$containerClassName ?>__right__inner">
                                    <?php
                                    echo wp_get_attachment_image( $image[ 'id' ], 'large' );
                                    ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

class BlogFooter extends ContentClass
{
    protected static $containerClassName = 'eightball-block__blog-footer-block';
    protected static $contentInsideContainer = false;
    protected static $settings = 'blog_archive_footer_settings';
    protected static $options = true;

    protected function createLayout() {
        $main_title = get_field( 'main_title', 'option' );
        $description = get_field( 'description', 'option' );
        $form_shortcode = get_field( 'blog_form_shortcode', 'option' );
        $footer_menu = get_field( 'footer_menu', 'option' );
        $logo = get_field( 'logo', 'option' );
        $social_media_links = get_field( 'social_media_links', 'options' );
        ?>
        <div class="container-fluid archive-post__footer">
            <div class="row">
                <div class="offset-xxl-2 col-xxl-8 offset-lg-1 col-lg-10 col-12">
                    <div class="row">
                        <div class="col-xl-5 col-lg-6">
                            <?php if ( $main_title ): ?>
                                <h3 class="h1 <?= static::$containerClassName ?>__main-title">
                                    <?= $main_title ?>
                                </h3>

                                <hr>
                            <?php endif; ?>

                            <?php if ( $description ): ?>
                                <p class="intro-text <?= static::$containerClassName ?>__desc">
                                    <?= $description ?>
                                </p>
                            <?php endif; ?>
                        </div>

                        <div class="col-xl-4 col-lg-6 <?= static::$containerClassName ?>__middle">
                            <?php
                            if ( $form_shortcode ):
                                echo do_shortcode( $form_shortcode );
                            endif;
                            ?>
                        </div>

                        <div class="col-xl-3 col-lg-12 <?= static::$containerClassName ?>__right">
                            <?php if ( $footer_menu ): ?>
                                <div class=" <?= static::$containerClassName ?>__menu">
                                    <?php foreach ( $footer_menu as $menu ): ?>
                                        <a href="">
                                            <?= $menu[ 'link' ][ 'title' ] ?>
                                        </a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <div class="<?= static::$containerClassName ?>__right__logo">
                                <?php
                                if ( $logo ):
                                    echo wp_get_attachment_image( $logo[ 'id' ], 'full' );
                                endif;

                                if ( $social_media_links ):
                                    ?>
                                    <div class=" <?= static::$containerClassName ?>__social-menu">
                                        <?php foreach ( $social_media_links as $link ): ?>
                                            <a href="<?= $link[ 'link' ] ?>" target="_blank">
                                                <?= $link[ 'icon' ] ?>
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

genesis();