<?php

// Constants
$theme = wp_get_theme();
define( 'THEME_VERSION', $theme->Version );
define( 'THEME_DIR', get_stylesheet_directory() );
define( 'THEME_URI', get_stylesheet_directory_uri() );

// Include theme functions etc
foreach ( glob( THEME_DIR . "/includes/*.php" ) as $file ) {
    require $file;
}

// Content Class
foreach ( glob( THEME_DIR . "/includes/content/*.php" ) as $file ) {
    require $file;
}

// Theme styles and scripts
add_action( 'wp_enqueue_scripts', 'eightball_load_scripts' );
function eightball_load_scripts() {
    // Styles
    wp_register_style( 'swiper', THEME_URI . '/vendor/css/swiper-bundle.min.css', [], THEME_VERSION );
    wp_register_style( 'fancybox', THEME_URI . '/vendor/css/jquery.fancybox.min.css', [], THEME_VERSION );
    wp_enqueue_style( 'main', THEME_URI . '/dist/css/style.css', [], THEME_VERSION );

    // Google Fonts
    wp_enqueue_style( 'google-font-fira', 'https://fonts.googleapis.com/css2?family=Fira+Sans:wght@600&display=swap', [], THEME_VERSION );
    wp_enqueue_style( 'google-font-raleway', 'https://fonts.googleapis.com/css2?family=Raleway:wght@400&display=swap', [], THEME_VERSION );

    // Blocks
    wp_register_script( 'heading-featured-list', THEME_URI . '/dist/js/heading-featured-list.js', [ 'swiper' ], THEME_VERSION, true );
    wp_register_script( 'faqs', THEME_URI . '/dist/js/faqs.js', [], THEME_VERSION, true );
    wp_register_script( 'reviews', THEME_URI . '/dist/js/reviews.js', [ 'swiper' ], THEME_VERSION, true );

    // Scripts
    wp_register_script( 'swiper', THEME_URI . '/vendor/js/swiper-bundle.min.js', [ 'jquery' ], THEME_VERSION, true );
    wp_register_script( 'fancybox', THEME_URI . '/vendor/js/jquery.fancybox.min.js', [ 'jquery' ], THEME_VERSION, true );
    wp_enqueue_script( 'main', THEME_URI . '/dist/js/scripts.js', [ 'jquery' ], THEME_VERSION, true );

    if ( ! is_user_logged_in() ) {
        wp_deregister_style( 'dashicons' );
    }

    wp_deregister_script( 'superfish' );
    wp_deregister_script( 'superfish-args' );
    wp_dequeue_style('wp-block-library');
    wp_dequeue_style('wp-block-library-theme');
    wp_dequeue_style('wc-block-style');
}

add_filter( 'style_loader_tag', 'eightball_preload_fonts', 10, 3 );
function eightball_preload_fonts( $tag, $handle, $src ) {
    if ( $handle === 'google-font-fira' || $handle === 'google-font-raleway' ) {
        $tag = '<link id="' . $handle . '" rel="stylesheet preload prefetch"  href="' . $src . '"as="style" type="text/css" crossorigin />';
    }

    return $tag;
}

// Styles for visual editor
add_action( 'after_setup_theme', 'eightball_add_editor_styles' );
function eightball_add_editor_styles() {
    add_editor_style( THEME_URI . '/dist/css/editor.css' );
}

// Image Sizes
add_image_size( 'banner-size', 1920, 9999, false );

// additional nav menus
add_action( 'init', 'eightball_nav_menus' );
function eightball_nav_menus() {
    register_nav_menu( 'header-right', __( 'Header Right Menu' ) );
}

// Add new formats to TinyMCE
add_filter( 'tiny_mce_before_init', 'eightball_add_formats' );
function eightball_add_formats( $init_array ) {
    $style_formats = [
        [
            'title' => 'Text Formats',
            'items' => [
                [
                    'title' => 'Intro Text',
                    'selector' => 'p',
                    'classes' => 'intro-text',
                ],
                [
                    'title' => 'Border below Text',
                    'selector' => '*',
                    'classes' => 'has-bottom-line',
                ],
            ]
        ],
//        [
//            'title' => 'Buttons',
//            'items' => [
//                [
//                    'title' => 'Button',
//                    'selector' => 'a',
//                    'classes' => 'button',
//                    'wrapper' => false,
//                ],
//                [
//                    'title' => 'Button with border',
//                    'selector' => 'a',
//                    'classes' => 'button-border',
//                    'wrapper' => false,
//                ],
//                [
//                    'title' => 'Button with background colour',
//                    'selector' => 'a',
//                    'classes' => 'button button-bg',
//                    'wrapper' => false,
//                ],
//            ]
//        ]
    ];

    $init_array[ "style_formats" ] = wp_json_encode( $style_formats );
    return $init_array;
}

// Site Options
if ( function_exists( 'acf_add_options_page' ) ) {
    acf_add_options_page();
}

if ( function_exists( 'acf_set_options_page_title' ) ) {
    acf_set_options_page_title( __( 'Site Options' ) );
}

// Blog option
if ( function_exists( 'acf_add_options_page' ) ) {
    acf_add_options_page( array(
        'page_title' => 'Blog Options',
        'menu_title' => 'Options',
        'menu_slug' => 'blog-options',
        'capability' => 'edit_posts',
        'parent_slug' => 'edit.php',
        'position' => false,
        'redirect' => false,
    ) );
}

// Site URL shortcode
add_shortcode( 'site_url', function ( $atts = null, $content = null ) {
    return site_url();
} );

// Sitemap
add_shortcode( 'sitemapshortcode', 'eightball_sitemap_shortcode' );
function eightball_sitemap_shortcode( $atts ) {
    $exclude_pages = get_field( 'exclude_pages_site_map', 'options' );

    $args2 = [
        'exclude' => $exclude_pages,
        'title_li' => null
    ];

    ob_start();
    ?>
    <div class="eightball__sitemap">
        <?php wp_list_pages( $args2 ) ?>
    </div>
    <?php
    return ob_get_clean();
}

// Excerpt length
add_filter( 'excerpt_length', 'cs_excerpt_length', 999 );
function cs_excerpt_length( $length ) {
    return 20;
}

function cs_excerpt( $num ) {
    $limit = $num + 1;
    $excerpt = explode( ' ', get_the_excerpt(), $limit );
    array_pop( $excerpt );
    $excerpt = implode( ' ', $excerpt ) . '... ';
    echo $excerpt;
}

add_filter( 'gform_submit_button', 'form_submit_button', 10, 2 );
function form_submit_button( $button, $form ) {
    $button_text = $form[ 'button' ][ 'text' ] ? $form[ 'button' ][ 'text' ] : 'Submit';

    return "<button class='button gform_button' id='gform_submit_button_{$form['id']}'><span>{$button_text}</span></button>";
}
