<?php

use eightball\ContentClass;

if ( !class_exists( 'TwoColumnLayout' ) ) {

    class TwoColumnLayout extends ContentClass
    {
        protected static $rowClassName = 'eightball-block__two-column__row';
        protected static $settings = 'two_column_layout_settings';
        protected static $containerClassName = 'eightball-block__two-column';
        protected static $contentInsideContainer = true;

        private function addCTAClass( $class ) {
            $classes = '';
            switch ( $class ) {
                case 'red-bg':
                    $classes = 'cs-button__red';
                    break;
                case 'gold-bg':
                    $classes = 'cs-button__gold';
                    break;
                case 'regular':
                    $classes = 'cs-button__reg';
                    break;
            }

            return $classes;
        }

        protected function createLayout() {
            $left = get_field( 'left_column' );
            $right = get_field( 'right_column' );

            $left_width = get_field( 'left_column_width' );
            $right_width = get_field( 'right_column_width' );

            $left_offset = get_field( 'left_column_offset' );
            $right_offset = get_field( 'right_column_offset' );

            // CTAs
            $left_has_cta = get_field( 'left_has_multiple_ctas' );
            $right_has_cta = get_field( 'right_has_multiple_ctas' );
            $left_ctas = get_field( 'left_ctas' );
            $right_ctas = get_field( 'right_ctas' );

            $row_alignment = static::$rowClassName . '__' . get_field( 'two_column_alignment' );

            $left_col_order = get_field( 'right_mobile_order' ) ? 'order-2 order-lg-1' : 'order-1';
            $right_col_order = get_field( 'right_mobile_order' ) ? 'order-1 order-lg-2' : 'order-2';

            ?>
            <div class="row <?= static::$rowClassName . ' ' . $row_alignment ?>">
                <div class="col-xl-<?= $left_width ?> offset-xl-<?= $left_offset ?> col-lg-6 col-12 eightball-block__two-column__left <?= $left_col_order ?>">
                    <?= $left ?>

                    <?php if ( $left_has_cta ): ?>
                        <div class="eightball-block__two-column__left-ctas">
                            <?php foreach ( $left_ctas as $cta ): ?>
                                <a class="<?= $this->addCTAClass( $cta[ 'style' ] ) ?>"
                                   href="<?= $cta[ 'link' ][ 'url' ] ?>"
                                   target="<?= $cta[ 'link' ][ 'target' ] ?: '_self' ?>">
                                    <?= $cta[ 'link' ][ 'title' ] ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="col-xl-<?= $right_width ?> offset-xl-<?= $right_offset ?> col-lg-6 col-12 eightball-block__two-column__right <?= $right_col_order ?>">
                    <?= $right ?>

                    <?php if ( $right_has_cta && $right_ctas ): ?>
                        <div class="eightball-block__two-column__right-ctas">
                            <?php foreach ( $right_ctas as $cta ): ?>
                                <a class="<?= $this->addCTAClass( $cta[ 'style' ] ) ?>"
                                   href="<?= $cta[ 'link' ][ 'url' ] ?>"
                                   target="<?= $cta[ 'link' ][ 'target' ] ?: '_self' ?>">
                                    <?= $cta[ 'link' ][ 'title' ] ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        }
    }
}

$twoColumnLayout = new TwoColumnLayout();
$twoColumnLayout->contentWrapper();