<?php

use eightball\ContentClass;

if (!class_exists('OurReviewsBlock')) {

    class OurReviewsBlock extends ContentClass
    {
        protected static $settings = 'block_our_reviews_settings';
        protected static $containerClassName = 'eightball-block__our-reviews-block';

        protected function createLayout()
        {
            $title = get_field('title');
            $reviews = get_field('reviews');
            $image = get_field('image');
            ?>

            <div class="row">
                <div class="col-xl-5 col-lg-6 <?= static::$containerClassName ?>__left">
                    <h2 class="has-bottom-line">
                        <?= $title ?>
                    </h2>

                    <?php if ($reviews): ?>
                        <div class="swiper-container <?= static::$containerClassName ?>__reviews">
                            <div class="swiper-wrapper">
                                <?php foreach ($reviews as $review): ?>
                                    <div class="swiper-slide">
                                        <p class="intro-text">
                                            <?= $review['text'] ?>
                                        </p>

                                        <p class="<?= static::$containerClassName ?>__reviews__name">
                                            <?= $review['name'] ?>
                                        </p>
                                    </div>
                                <?php endforeach; ?>
                            </div>

                            <i class="<?= static::$containerClassName ?>__prev fas fa-caret-left"></i>
                            <i class="<?= static::$containerClassName ?>__next fas fa-caret-right"></i>

                        </div>
                    <?php endif; ?>
                </div>

                <div class="offset-xl-1 col-lg-6 <?= static::$containerClassName ?>__right">
                    <?= wp_get_attachment_image($image['id'], 'large') ?>
                </div>
            </div>

            <?php
        }
    }
}

$ourReviewsBlock = new OurReviewsBlock();
$ourReviewsBlock->contentWrapper();