<?php

use eightball\ContentClass;

if (!class_exists('MainFooterBlock')) {

    class MainFooterBlock extends ContentClass
    {
        protected static $settings = 'eightball-block__main-footer-block-settings';
        protected static $containerClassName = 'eightball-block__main-footer-block';

        protected function createLayout()
        {
            $main_title = get_field('main_title');
            $description = get_field('description');
            $cta = get_field('cta');
            $form_shortcode = get_field('form_shortcode', 'option');
            $footer_menu = get_field('footer_menu', 'option');
            $logo = get_field('logo', 'option');
            $social_media_links = get_field('social_media_links', 'options');
            ?>

            <div class="row">
                <div class="col-xl-5 col-lg-6">
                    <?php if ($main_title): ?>
                        <h3 class="h1 <?= static::$containerClassName ?>__main-title">
                            <?= $main_title ?>
                        </h3>

                        <hr>
                    <?php endif; ?>

                    <?php if ($description): ?>
                        <p class="intro-text <?= static::$containerClassName ?>__desc">
                            <?= $description ?>
                        </p>
                    <?php endif; ?>

                    <?php if ($cta): ?>
                        <a class="cs-button__gold" href="<?= $cta['url'] ?>"
                           target="<?= $cta['target'] ? $cta['target'] : '_self' ?>">
                            <?= $cta['title'] ?>
                        </a>
                    <?php endif; ?>
                </div>

                <div class="col-xl-4 col-lg-6 <?= static::$containerClassName ?>__middle">
                    <?php
                    if ($form_shortcode):
                        echo do_shortcode($form_shortcode);
                    endif;
                    ?>
                </div>

                <div class="col-xl-3 col-lg-12 <?= static::$containerClassName ?>__right">
                    <?php if ($footer_menu): ?>
                        <div class=" <?= static::$containerClassName ?>__menu">
                            <?php foreach ($footer_menu as $menu): ?>
                                <a href="<?= $menu['link']['url'] ?>">
                                    <?= $menu['link']['title'] ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <div class="<?= static::$containerClassName ?>__right__logo">
                        <?php
                        if ($logo):
                            echo wp_get_attachment_image($logo['id'], 'full');
                        endif;

                        if ($social_media_links):
                            ?>
                            <div class=" <?= static::$containerClassName ?>__social-menu">
                                <?php foreach ($social_media_links as $link): ?>
                                    <a href="<?= $link['link'] ?>" target="_blank">
                                        <?= $link['icon'] ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>

            <?php
        }
    }
}

$mainFooterBlock = new MainFooterBlock();
$mainFooterBlock->contentWrapper();