<?php

use eightball\ContentClass;

if (!class_exists('ImageRepeaterBlock')) {

    class ImageRepeaterBlock extends ContentClass
    {
        protected static $settings = 'block_image_repeater_settings';
        protected static $containerClassName = 'eightball-block__image-repeater-block';

        protected function createLayout()
        {
            $images = get_field('images');
            $text = get_field('text');

            if ($images):
                ?>
                <div class="row <?= static::$containerClassName ?>__row">
                    <?php foreach ($images as $image): ?>
                        <div class="<?= static::$containerClassName ?>__col">
                            <?= wp_get_attachment_image($image['image']['id'], 'medium') ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php
            endif;
            if ($text):
                ?>
            <p class="<?= static::$containerClassName ?>__text">
                <?= $text ?>
            </p>
            <?php
            endif;
        }
    }
}

$imageRepeaterBlock = new ImageRepeaterBlock();
$imageRepeaterBlock->contentWrapper();