<?php

use eightball\ContentClass;

if ( !class_exists( 'HomePageBannerBlock' ) ) {

    class HomePageBannerBlock extends ContentClass
    {
        protected static $settings = 'homepage_banner_block_settings';
        protected static $containerClassName = 'eightball-block__homepage-banner-block';
        protected static $colClassName = 'eightball-block__homepage-banner-block__col';

        protected function createLayout() {
            $content = get_field( 'content' );
            $has_services = get_field( 'has_services' );
            $has_usps = get_field( 'has_usps' );
            $services_to_select = get_field( 'services_to_select' );
            $right_image = get_field( 'right_image' );
            $usps = get_field( 'usps' );
            ?>
            <div class="row <?= static::$containerClassName ?>__top">
                <div class="col-lg-6 <?= static::$containerClassName ?>__left">
                    <?php if ( $content ): ?>
                        <div class="<?= static::$containerClassName ?>__content">
                            <?= $content ?>
                        </div>
                    <?php endif; ?>

                    <?php if ( $has_services ): ?>
                        <select name="services-to-select" class="services-to-select" id="services-to-select">
                            <option selected="selected">
                                Please select a service
                            </option>
                            <?php foreach ( $services_to_select as $service ): ?>
                                <option value="<?= get_the_permalink( $service->ID ) ?>">
                                    <?= $service->post_title ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    <?php endif; ?>
                </div>

                <div class="col-lg-6 <?= static::$containerClassName ?>__right">
                    <div class="<?= static::$containerClassName ?>__right__inner">
                        <?php
                        echo wp_get_attachment_image( $right_image[ 'id' ], 'large' );
                        //                        echo file_get_contents( $right_image[ 'url' ] );
                        //                        var_dump($right_image);
                        ?>
                    </div>
                </div>
            </div>

            <?php if ( $has_usps && $usps ): ?>
                <div class="<?= static::$containerClassName ?>__usps <?= static::$containerClassName ?>__bottom">
                    <div class="row">
                        <?php foreach ( $usps as $usp ): ?>
                            <div class="<?= static::$containerClassName ?>__usps__inner col-lg-4 col-md-6">
                                <?= wp_get_attachment_image( $usp[ 'image' ], 'thumbnail' ) ?>

                                <h5>
                                    <?= $usp[ 'text' ] ?>
                                </h5>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php
        }
    }
}

$homepageBannerBlock = new HomePageBannerBlock();
$homepageBannerBlock->contentWrapper();