<?php


use eightball\ContentClass;

if ( !class_exists( 'HeadingFeaturedList' ) ) {

    class HeadingFeaturedList extends ContentClass
    {
        protected static $settings = 'block_heading_featured_list_settings';
        protected static $containerClassName = 'eightball-block__heading-featured-list-block';

        protected function createLayout() {
            $heading = get_field( 'heading' );
            $heading_alignment = get_field( 'heading_alignment' );
            $description = get_field( 'description' );
            $featured_list = get_field( 'featured_list' );
            $cta = get_field( 'cta' );
            ?>

            <div class="row">
                <div class="<?= $description ? 'col-lg-4 ' . static::$containerClassName . '__heading' : 'col-xl-10 col-lg-10' ?> <?= $heading_alignment === 'center' ? 'offset-xl-1 offset-lg-1 text-center ' . static::$containerClassName . '__heading-center' : '' ?>">
                    <h2 class="has-bottom-line">
                        <?= $heading ?>
                    </h2>
                </div>

                <?php if ( $description ): ?>
                    <div class="offset-xl-1 col-xl-7 col-lg-8 <?= static::$containerClassName ?>__heading-desc">
                        <p class="intro-text">
                            <?= $description ?>
                        </p>
                    </div>
                <?php endif; ?>
            </div>

            <?php
            if ( $featured_list ):
                ?>
                <div class="<?= static::$containerClassName ?>__features row">
                    <?php foreach ( $featured_list as $item ): ?>
                        <div class="<?= static::$containerClassName ?>__col col-lg-4">
                            <?php if ( $item[ 'cta' ] ): ?>
                                <a class="<?= static::$containerClassName ?>__img__link"
                                   href="<?= $item[ 'cta' ][ 'url' ] ?>"
                                   target="<?= $item[ 'cta' ][ 'target' ] ?: '_self' ?>">
                                    <?= wp_get_attachment_image( $item[ 'icon' ][ 'id' ], 'thumbnail' ) ?>
                                </a>
                            <?php elseif ( $item[ 'icon' ] ): ?>
                                <div class="<?= static::$containerClassName ?>__img">
                                    <?= wp_get_attachment_image( $item[ 'icon' ][ 'id' ], 'thumbnail' ) ?>
                                </div>
                            <?php endif; ?>

                            <div class="<?= static::$containerClassName ?>__heading">
                                <?= '<' . $item[ 'heading_size' ] . '>' . $item[ 'heading' ] . '</' . $item[ 'heading_size' ] . '>' ?>
                            </div>

                            <p>
                                <?= $item[ 'description' ] ?>
                            </p>

                            <?php if ( $item[ 'cta' ] ): ?>
                                <a class="cs-button__red <?= static::$containerClassName ?>__cta"
                                   href="<?= $item[ 'cta' ][ 'url' ] ?>"
                                   target="<?= $item[ 'cta' ][ 'target' ] ?: '_self' ?>">
                                    <?= $item[ 'cta' ][ 'title' ] ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="swiper-container <?= static::$containerClassName ?>__features__mobile">
                    <div class="swiper-wrapper">
                        <?php foreach ( $featured_list as $item ): ?>
                            <div class="swiper-slide">
                                <div class="<?= static::$containerClassName ?>__col">
                                    <?php if ( $item[ 'icon' ] ): ?>
                                        <div class="<?= static::$containerClassName ?>__img">
                                            <?= wp_get_attachment_image( $item[ 'icon' ][ 'id' ], 'thumbnail' ) ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="<?= static::$containerClassName ?>__heading">
                                        <?= '<' . $item[ 'heading_size' ] . '>' . $item[ 'heading' ] . '</' . $item[ 'heading_size' ] . '>' ?>
                                    </div>

                                    <p class="<?= static::$containerClassName ?>__desc">
                                        <?= $item[ 'description' ] ?>
                                    </p>

                                    <?php if ( $item[ 'cta' ] ): ?>
                                        <a class="cs-button__red <?= static::$containerClassName ?>__cta"
                                           href="<?= $item[ 'cta' ][ 'url' ] ?>"
                                           target="<?= $item[ 'cta' ][ 'target' ] ?: '_self' ?>">
                                            <?= $item[ 'cta' ][ 'title' ] ?>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <i class="<?= static::$containerClassName ?>__prev fas fa-caret-left"></i>
                    <i class="<?= static::$containerClassName ?>__next fas fa-caret-right"></i>
                </div>

            <?php
            endif;

            if ( $cta ):
                ?>
                <div class="<?= static::$containerClassName ?>__bottom-cta">
                    <a href="<?= $cta[ 'url' ] ?>" class="cs-button__red" target="<?= $cta[ 'target' ] ?: '_self' ?>">
                        <?= $cta[ 'title' ] ?>
                    </a>
                </div>
            <?php endif;
        }
    }
}

$headingFeaturedList = new HeadingFeaturedList();
$headingFeaturedList->contentWrapper();

