<?php

use eightball\ContentClass;

if (!class_exists('FAQsBlock')) {

    class FAQsBlock extends ContentClass
    {
        protected static $settings = 'block_faqs_settings';
        protected static $containerClassName = 'eightball-block__faqs-block';

        protected function createLayout()
        {
            $heading = get_field('heading');
            $faqs = get_field('faqs');

            ?>
            <div class="row">
                <?= $heading ? "<h3 class=" . static::$containerClassName . "__heading" . "> $heading</h3>" : '' ?>
            </div>

            <?php
            if ($faqs):
                ?>
                <div class="<?= static::$containerClassName ?>__faqs">
                    <?php
                    foreach ($faqs as $key=>$faq):
                        ?>
                        <div class="<?= static::$containerClassName ?>__faqs__row">
                            <h5 class="<?= static::$containerClassName ?>__faqs__row__question <?= $key === 0 ? 'active' : '' ?>">
                                <?= $faq['question'] ?>

                                <i class="fas fa-plus"></i>
                            </h5>

                            <p class="<?= static::$containerClassName ?>__faqs__row__answer">
                                <?= $faq['answer'] ?>
                            </p>
                        </div>
                    <?php
                    endforeach;
                    ?>
                </div>
            <?php
            endif;
        }
    }
}

$faqsBlock = new FAQsBlock();
$faqsBlock->contentWrapper();