<?php

use eightball\ContentClass;

if (!class_exists('ContactUsBlock')) {

    class ContactUsBlock extends ContentClass
    {
        protected static $settings = 'block_contact_settings';
        protected static $containerClassName = 'eightball-block__contact-block';

        protected function createLayout()
        {
            $left = get_field('left_column');
            $right = get_field('right_column');
            ?>
            <div class="row <?= static::$containerClassName ?>__row">
                <div class="col-xxl-5 col-lg-6 <?= static::$containerClassName ?>__left pr-5">
                    <h2 class="has-bottom-line">
                        <?= $left['heading'] ?>
                    </h2>

                    <p class="intro-text">
                        <?= $left['description'] ?>
                    </p>

                    <?php if ($left['email']): ?>
                        <div class="<?= static::$containerClassName ?>__email">
                            <div class="intro-text">
                                Email
                            </div>
                            <a href="<?= $left['email']['url'] ?>">
                                <?= $left['email']['title'] ?>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if ($left['phone']): ?>
                        <div class="<?= static::$containerClassName ?>__phone">
                            <div class="intro-text">
                                Phone
                            </div>
                            <a href="<?= $left['phone']['url'] ?>">
                                <?= $left['phone']['title'] ?>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if ($left['operating_hours']): ?>
                    <div class="<?= static::$containerClassName ?>__address">
                        <div class="intro-text">
                            Opening Hours
                        </div>

                        <p>
                            <?= $left['operating_hours'] ?>
                        </p>
                    </div>
                    <?php endif; ?>

                </div>

                <div class="col-xxl-7 col-lg-6">
                    <?= do_shortcode($right['contact_form_shortcode']) ?>
                </div>
            </div>
            <?php
        }
    }
}

$contactUsBlock = new ContactUsBlock();
$contactUsBlock->contentWrapper();