<?php

use eightball\ContentClass;

if (!class_exists('AltFooterBlock')) {

    class AltFooterBlock extends ContentClass
    {
//        protected static $settings = 'block_contact_settings';
        protected static $containerClassName = 'eightball-block__alt-footer-block';
        protected static $contentInsideContainer = false;

        protected function createLayout()
        {
            $links = get_field('links');
            $text = get_field('text');
            $logo = get_field('logo');
            $social_media_links = get_field('social_media_links', 'options');

            ?>
            <div class="container-fluid">
                <div class="offset-xxl-2 col-xxl-8 offset-lg-1 col-lg-10 col-12 <?= static::$containerClassName ?>__wrapper">
                    <div class="row <?= static::$containerClassName ?>__row">
                        <div class="col-xl-5">
                            <div class="<?= static::$containerClassName ?>__links">
                                <?php foreach ($links as $link): ?>
                                    <a href="<?= $link['link']['url'] ?>">
                                        <?= $link['link']['title'] ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <div class="offset-xl-2 col-xl-5 <?= static::$containerClassName ?>__right">
                            <div class="<?= static::$containerClassName ?>__right__text">
                                <p class="intro-text">
                                    <?= $text ?>
                                </p>
                            </div>

                            <div class="<?= static::$containerClassName ?>__right__social">
                                <?php
                                if ($logo):
                                    echo wp_get_attachment_image($logo['id'], 'full');
                                endif;

                                if ($social_media_links):
                                    ?>
                                    <div class=" <?= static::$containerClassName ?>__social-menu">
                                        <?php foreach ($social_media_links as $link): ?>
                                            <a href="<?= $link['link'] ?>" target="_blank">
                                                <?= $link['icon'] ?>
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <?php
        }
    }
}

$altFooterBlock = new AltFooterBlock();
$altFooterBlock->contentWrapper();