<?php
add_action( 'genesis_loop', 'p2_do_404_loop' );
function p2_do_404_loop() {
    ?>
    <div class="eightball-404">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h3>
                        404: PAGE NOT FOUND
                    </h3>

                    <h1>
                        OOPS!
                    </h1>

                    <p>
                        How did we get here? Not to worry, we will help you get on the right track.
                        <br>
                        Please select a service that's relevant for you below.
                    </p>

                    <?php
                    $services = get_posts( [ 'post_type' => 'page', 'posts_per_page' => -1, 'orderby' => 'date', 'order' => 'ASC' ] );
                    ?>
                    <select name="services-404" id="services-404" class="services-404">

                    <?php

                    foreach ( $services as $service ) {
                        echo '<option value="' . get_the_permalink( $service->ID ) . '"> ' . get_the_title( $service->ID ) . '</option>';
                    }
                    ?>

                    </select>
                </div>
            </div>
        </div>
    </div>

    <?php
}


add_action( 'genesis_footer', function () {
    ?>
    <script>
        jQuery(document).ready(function ($) {
            $('#services-404').on('change', function () {
                var url = $(this).val(); // get selected value
                if (url) { // require a URL
                    window.location = url; // redirect
                }
                return false;
            });
        });
    </script>
    <?php
} );

remove_action( 'genesis_loop', 'genesis_404' );
add_filter( 'genesis_noposts_text', '__return_empty_string' );

genesis();
