<?php

namespace WPSynchro\Utilities\Actions;

use WPSynchro\Utilities\Actions\Action;
use WPSynchro\MigrationFactory;
use WPSynchro\Job;

/**
 * Action: Send sync error email
 * @since 1.6.0
 */
class EmailOnSyncFailure implements Action
{

    /**
     * Initialize
     * @since 1.6.0
     */
    public function init()
    {
        static $added = null;
        if ($added !== true) {
            add_action("wpsynchro_migration_failure", function () {
                (new self())->doAction(func_get_args());
            }, 10, 2);
        }
        $added = true;
    }

    /**
     * Execute action
     * @since 1.6.0
     */
    public function doAction($params)
    {
        $migration_id = $params[0];
        $job_id = $params[1];

        // Get migration
        $migration_factory = new MigrationFactory();
        $migration = $migration_factory->retrieveMigration($migration_id);
        if (!$migration) {
            return;
        }

        // Get job
        $job = new Job();
        $job_load_result = $job->load($migration_id, $job_id);
        if (!$job_load_result) {
            return;
        }

        // Get emails to send to, and send
        $emails = $migration->getFailureEmailList();
        if (count($emails) > 0) {
            $subject = $this->getSubject($migration->site_url);
            $content = $this->getContent($migration->site_url);
            $headers = ['Content-Type: text/plain; charset=UTF-8'];
            foreach ($emails as $email) {
                wp_mail($email, $subject, $content, $headers);
            }
        }
    }

    /**
     * Get subject
     * @since 1.6.0
     */
    public function getSubject($to)
    {
        return sprintf(__("[Migration failed] - Sync to %s failed", "wpsynchro"), $to);
    }

    /**
     * Get email content
     * @since 1.6.0
     */
    public function getContent($to)
    {
        $current_url = get_home_url();

        return sprintf(
            __(
                "Hi, \r\n
We just want to notify you that a migration has failed.
The migration is to %s \r\n
Migration is running on %s \r\n
This is an automated email generated by WP Synchro plugin.",
                "wpsynchro"
            ),
            $to,
            $current_url
        );
    }
}
